using System;
using System.Collections;
using System.ComponentModel;
using System.Configuration.Install;
using System.Resources;
using System.Reflection;

namespace gov.va.med.vbecs.ExceptionManagement
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Installer class used to create two event sources for the
		///Exception Management Application Block to function correctly.
		///</summary>

		#endregion

	[RunInstaller(true)]
	public class ExceptionManagerInstaller : System.Configuration.Install.Installer
	{
		private System.Diagnostics.EventLogInstaller exceptionManagerEventLogInstaller;
		private System.Diagnostics.EventLogInstaller exceptionManagementEventLogInstaller;
		
		private static ResourceManager resourceManager = new ResourceManager("gov.va.med.vbecs.Common.ExceptionManagerText",Assembly.GetAssembly(typeof(ExceptionManager)));
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2585"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ExceptionManagerInstaller object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3111"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor with no params.
		/// </summary>
		public ExceptionManagerInstaller()
		{
			// Initialize variables.
			InitializeComponent();
		}

		/// <summary>
		/// Initialization function to set internal variables.
		/// </summary>
		private void InitializeComponent()
		{
			this.exceptionManagerEventLogInstaller = new System.Diagnostics.EventLogInstaller();
			this.exceptionManagementEventLogInstaller = new System.Diagnostics.EventLogInstaller();
			// 
			// exceptionManagerEventLogInstaller
			// 
			this.exceptionManagerEventLogInstaller.Log = "Application";
			this.exceptionManagerEventLogInstaller.Source = resourceManager.GetString("RES_EXCEPTIONMANAGER_INTERNAL_EXCEPTIONS");
			// 
			// exceptionManagementEventLogInstaller
			// 
			this.exceptionManagementEventLogInstaller.Log = "Application";
			this.exceptionManagementEventLogInstaller.Source = resourceManager.GetString("RES_EXCEPTIONMANAGER_PUBLISHED_EXCEPTIONS");

			this.Installers.AddRange(new System.Configuration.Install.Installer[] {
																					  this.exceptionManagerEventLogInstaller,
																					  this.exceptionManagementEventLogInstaller});
		}
	}
}
